/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.content.logistics.item.filter.attribute.SingletonItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.AddedByAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.BookAuthorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.BookCopyAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ColorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.EnchantAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.FluidContentsAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InItemGroupAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ItemNameAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryAmuletAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryAttunementAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryCrystalAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery.AstralSorceryPerkGemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.legacydeserializers.AllItemAttributeLegacyDeserializers;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_3962;

public class AllItemAttributeTypes {
    private static final ItemStackHandlerContainer RECIPE_WRAPPER = new ItemStackHandlerContainer();
    public static final ItemAttributeType PLACEABLE = AllItemAttributeTypes.singleton("placeable", (class_1799 s) -> s.method_7909() instanceof class_1747);
    public static final ItemAttributeType CONSUMABLE = AllItemAttributeTypes.singleton("consumable", class_1799::method_19267);
    public static final ItemAttributeType FLUID_CONTAINER = AllItemAttributeTypes.singleton("fluid_container", (class_1799 s) -> ContainerItemContext.withConstant((class_1799)s).find(FluidStorage.ITEM) != null);
    public static final ItemAttributeType ENCHANTED = AllItemAttributeTypes.singleton("enchanted", class_1799::method_7942);
    public static final ItemAttributeType MAX_ENCHANTED = AllItemAttributeTypes.singleton("max_enchanted", AllItemAttributeTypes::maxEnchanted);
    public static final ItemAttributeType RENAMED = AllItemAttributeTypes.singleton("renamed", class_1799::method_7938);
    public static final ItemAttributeType DAMAGED = AllItemAttributeTypes.singleton("damaged", class_1799::method_7986);
    public static final ItemAttributeType BADLY_DAMAGED = AllItemAttributeTypes.singleton("badly_damaged", (class_1799 s) -> s.method_7986() && (float)s.method_7919() / (float)s.method_7936() > 0.75f);
    public static final ItemAttributeType NOT_STACKABLE = AllItemAttributeTypes.singleton("not_stackable", ((Predicate<class_1799>)class_1799::method_7946).negate());
    public static final ItemAttributeType EQUIPABLE = AllItemAttributeTypes.singleton("equipable", (class_1799 s) -> class_1309.method_32326((class_1799)s).method_5925() != class_1304.class_1305.field_6177);
    public static final ItemAttributeType FURNACE_FUEL = AllItemAttributeTypes.singleton("furnace_fuel", class_2609::method_11195);
    public static final ItemAttributeType WASHABLE = AllItemAttributeTypes.singleton("washable", AllFanProcessingTypes.SPLASHING::canProcess);
    public static final ItemAttributeType HAUNTABLE = AllItemAttributeTypes.singleton("hauntable", AllFanProcessingTypes.HAUNTING::canProcess);
    public static final ItemAttributeType CRUSHABLE = AllItemAttributeTypes.singleton("crushable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, AllRecipeTypes.CRUSHING.getType()) || AllItemAttributeTypes.testRecipe(s, w, AllRecipeTypes.MILLING.getType()));
    public static final ItemAttributeType SMELTABLE = AllItemAttributeTypes.singleton("smeltable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, class_3956.field_17546));
    public static final ItemAttributeType SMOKABLE = AllItemAttributeTypes.singleton("smokable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, class_3956.field_17548));
    public static final ItemAttributeType BLASTABLE = AllItemAttributeTypes.singleton("blastable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, class_3956.field_17547));
    public static final ItemAttributeType COMPOSTABLE = AllItemAttributeTypes.singleton("compostable", (class_1799 s) -> class_3962.field_17566.containsKey((Object)s.method_7909()));
    public static final ItemAttributeType IN_TAG = AllItemAttributeTypes.register("in_tag", new InTagAttribute.Type());
    public static final ItemAttributeType IN_ITEM_GROUP = AllItemAttributeTypes.register("in_item_group", new InItemGroupAttribute.Type());
    public static final ItemAttributeType ADDED_BY = AllItemAttributeTypes.register("added_by", new AddedByAttribute.Type());
    public static final ItemAttributeType HAS_ENCHANT = AllItemAttributeTypes.register("has_enchant", new EnchantAttribute.Type());
    public static final ItemAttributeType SHULKER_FILL_LEVEL = AllItemAttributeTypes.register("shulker_fill_level", new ShulkerFillLevelAttribute.Type());
    public static final ItemAttributeType HAS_COLOR = AllItemAttributeTypes.register("has_color", new ColorAttribute.Type());
    public static final ItemAttributeType HAS_FLUID = AllItemAttributeTypes.register("has_fluid", new FluidContentsAttribute.Type());
    public static final ItemAttributeType HAS_NAME = AllItemAttributeTypes.register("has_name", new ItemNameAttribute.Type());
    public static final ItemAttributeType BOOK_AUTHOR = AllItemAttributeTypes.register("book_author", new BookAuthorAttribute.Type());
    public static final ItemAttributeType BOOK_COPY = AllItemAttributeTypes.register("book_copy", new BookCopyAttribute.Type());
    public static final ItemAttributeType ASTRAL_AMULET = AllItemAttributeTypes.register("astral_amulet", new AstralSorceryAmuletAttribute.Type());
    public static final ItemAttributeType ASTRAL_ATTUNMENT = AllItemAttributeTypes.register("astral_attunment", new AstralSorceryAttunementAttribute.Type());
    public static final ItemAttributeType ASTRAL_CRYSTAL = AllItemAttributeTypes.register("astral_crystal", new AstralSorceryCrystalAttribute.Type());
    public static final ItemAttributeType ASTRAL_PERK_GEM = AllItemAttributeTypes.register("astral_perk_gem", new AstralSorceryPerkGemAttribute.Type());

    private static <T extends class_1860<class_1263>> boolean testRecipe(class_1799 s, class_1937 w, class_3956<T> type) {
        RECIPE_WRAPPER.method_5447(0, s.method_7972());
        return w.method_8433().method_8132(type, (class_1263)RECIPE_WRAPPER, w).isPresent();
    }

    private static boolean maxEnchanted(class_1799 s) {
        return class_1890.method_8222((class_1799)s).entrySet().stream().anyMatch(e -> ((class_1887)e.getKey()).method_8183() <= (Integer)e.getValue());
    }

    private static ItemAttributeType singleton(String id, Predicate<class_1799> predicate) {
        return AllItemAttributeTypes.register(id, new SingletonItemAttribute.Type(type -> new SingletonItemAttribute((SingletonItemAttribute.Type)type, (stack, level) -> predicate.test((class_1799)stack), id)));
    }

    private static ItemAttributeType singleton(String id, BiPredicate<class_1799, class_1937> predicate) {
        return AllItemAttributeTypes.register(id, new SingletonItemAttribute.Type(type -> new SingletonItemAttribute((SingletonItemAttribute.Type)type, predicate, id)));
    }

    private static ItemAttributeType register(String id, ItemAttributeType type) {
        return (ItemAttributeType)class_2378.method_10230(CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE, (class_2960)Create.asResource(id), (Object)type);
    }

    public static void init() {
    }

    static {
        AllItemAttributeLegacyDeserializers.register();
    }
}

